﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;

namespace Inet.Viewer.Data
{
    /// <summary>
    /// This Loader specifically loads the ReportInfo data and sets it ot the IReportView.
    /// </summary>
    public class ReportInfoLoader : Loader
    {
        private IReportView view;

        /// <summary>
        /// The loaded ReportInfo will be added to the IReportView
        /// </summary>
        /// <param name="view"></param>
        public ReportInfoLoader(IReportView view)
        {
            this.view = view;
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        protected internal override bool Load(int token)
        {
            if (token == ViewerTokenConstants.TokenReportInfo)
            {
                ReportInfo info = new ReportInfo();

                int flags = ReadInt();
                info.IsFormPrint = (flags & 1) > 0;
                info.IsPrintingEnabled = (flags & 2) > 0;
                info.IsClipboardEnabled = (flags & 4) > 0;
                info.IsExportEnabled = (flags & 8) > 0;
                info.IsGroupTreeVisible = (flags & 16) > 0;
                info.IsFontScaling = (flags & 32) > 0;
                info.IsUserPageFormat = (flags & 64) > 0;
                info.IsStrongPDFEncryption = (flags & 128) > 0;
                info.IsReportSuppressed = (flags & 256) > 0;

                // Allowed export formats
                int count = ReadInt();
                info.Formats = new HashSet<string>();
                for (int i = 0; i < count; i++)
                {
                    info.Formats.Add(ReadString());
                }

                info.Title = ReadString();
                info.FileName = ReadString();
                view.ReportInfo = info;

                // the ReportInfo was read, so we can return                
                return false;
            }
            return true;
        }
    }
}
